/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ShiftGRP2_EvIb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] eSourceValue = new byte[2];
    int bitShift = 0;
    long shiftResult = 0L;
    int carryBit = 0;
    int newCarryBit = 0;

    public Instruction_ShiftGRP2_EvIb() {
    }

    public Instruction_ShiftGRP2_EvIb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.sourceValue = new byte[2];
        this.eSourceValue = new byte[2];
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.bitShift = (byte)(this.cpu.getByteFromCode() & 0x1F);
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL);
                this.carryBit = (this.shiftResult & 0x8000L) == 32768L ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.carryBit = (this.shiftResult & 0x8000L) == 32768L ? 1 : 0;
                    this.shiftResult = this.shiftResult << 1 & 0xFFFFL | (long)this.carryBit;
                }
                this.sourceValue[0] = (byte)(this.shiftResult >> 8);
                this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift == 1) {
                    this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[0] & 0x80) == 128 ? 1 : 0)) == 1;
                    break;
                }
                this.cpu.flags[11] = false;
                break;
            }
            case 1: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL);
                this.carryBit = (this.shiftResult & 1L) == 1L ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.carryBit = (this.shiftResult & 1L) == 1L ? 1 : 0;
                    this.shiftResult = this.shiftResult >> 1 | (long)(this.carryBit << 15);
                }
                this.sourceValue[0] = (byte)(this.shiftResult >> 8);
                this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift == 1) {
                    this.cpu.flags[11] = (this.sourceValue[0] >> 7 & 1 ^ this.sourceValue[0] >> 6 & 1) == 1;
                    break;
                }
                this.cpu.flags[11] = false;
                break;
            }
            case 2: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL);
                this.carryBit = this.cpu.flags[0] ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.newCarryBit = (this.shiftResult & 0x8000L) == 32768L ? 1 : 0;
                    this.shiftResult = this.shiftResult << 1 & 0xFFFFL | (long)this.carryBit;
                    this.carryBit = this.newCarryBit;
                }
                this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift == 1) {
                    this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[0] & 0x80) == 128 ? 1 : 0)) == 1;
                    break;
                }
                this.cpu.flags[11] = false;
                break;
            }
            case 3: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL);
                this.carryBit = this.cpu.flags[0] ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.newCarryBit = (this.shiftResult & 1L) == 1L ? 1 : 0;
                    this.shiftResult = this.shiftResult >> 1 & 0x7FFFL | (long)(this.carryBit << 15);
                    this.carryBit = this.newCarryBit;
                }
                this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift == 1) {
                    this.cpu.flags[11] = (this.sourceValue[0] >> 7 & 1 ^ this.sourceValue[0] >> 6 & 1) == 1;
                    break;
                }
                this.cpu.flags[11] = false;
                break;
            }
            case 4: {
                if (this.bitShift <= 0) break;
                if (this.cpu.doubleWord) {
                    if ((this.addressByte >> 6 & 3) == 3) {
                        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                        this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    } else {
                        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                        this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                        int n = (this.memoryReferenceLocation[1] & 0xFF) + 2;
                        if (n > 255) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                        }
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                        this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                    this.shiftResult = ((long)this.eSourceValue[0] << 24 & 0xFFFFFFFFFF000000L) + ((long)this.eSourceValue[1] << 16 & 0xFF0000L) + ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL) << this.bitShift - 1;
                    this.carryBit = (int)((this.shiftResult & Integer.MIN_VALUE) >> 31) & 1;
                    this.shiftResult <<= 1;
                    this.eSourceValue[0] = (byte)(this.shiftResult >> 24 & 0xFFL);
                    this.eSourceValue[1] = (byte)(this.shiftResult >> 16 & 0xFFL);
                    this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                    this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                    if ((this.addressByte >> 6 & 3) != 3) {
                        this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.eSourceValue);
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] - 2);
                        if (this.memoryReferenceLocation[1] == -1 || this.memoryReferenceLocation[1] == -2) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] - 1);
                        }
                        this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                    }
                } else {
                    if ((this.addressByte >> 6 & 3) == 3) {
                        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    } else {
                        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                        this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                    this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL) << this.bitShift - 1;
                    this.carryBit = (int)((this.shiftResult & 0x8000L) >> 15) & 1;
                    this.shiftResult <<= 1;
                    this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                    this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                    if ((this.addressByte >> 6 & 3) != 3) {
                        this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                    }
                }
                this.cpu.flags[4] = false;
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (!this.cpu.doubleWord) {
                    this.cpu.flags[11] = !(this.cpu.flags[0] && this.sourceValue[0] >> 7 == 1 || !this.cpu.flags[0] && this.sourceValue[0] >> 7 == 0);
                    this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0;
                    this.cpu.flags[7] = this.sourceValue[0] < 0;
                } else {
                    if (this.bitShift == 1) {
                        this.cpu.flags[11] = !(this.cpu.flags[0] && this.eSourceValue[0] >> 7 == 1 || !this.cpu.flags[0] && this.eSourceValue[0] >> 7 == 0);
                    }
                    this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0 && this.eSourceValue[0] == 0 && this.eSourceValue[1] == 0;
                    this.cpu.flags[7] = this.eSourceValue[0] < 0;
                }
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[1]);
                break;
            }
            case 5: {
                if (this.bitShift <= 0) break;
                if (this.cpu.doubleWord) {
                    if ((this.addressByte >> 6 & 3) == 3) {
                        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                        this.eSourceValue = this.cpu.decodeExtraRegister(this.addressByte & 7);
                    } else {
                        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                        this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                        int n = (this.memoryReferenceLocation[1] & 0xFF) + 2;
                        if (n > 255) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] + 1);
                        }
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] + 2);
                        this.eSourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                    if (this.bitShift == 1) {
                        this.cpu.flags[11] = (this.eSourceValue[0] & 0x80) == 128;
                    }
                    this.shiftResult = ((long)this.eSourceValue[0] << 24 & 0xFFFFFFFFFF000000L) + ((long)this.eSourceValue[1] << 16 & 0xFF0000L) + ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL) >> this.bitShift - 1;
                    this.carryBit = (int)(this.shiftResult & 1L);
                    this.shiftResult >>= 1;
                    this.eSourceValue[0] = (byte)(this.shiftResult >> 24 & 0xFFL);
                    this.eSourceValue[1] = (byte)(this.shiftResult >> 16 & 0xFFL);
                    this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                    this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                    if ((this.addressByte >> 6 & 3) != 3) {
                        this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.eSourceValue);
                        this.memoryReferenceLocation[1] = (byte)(this.memoryReferenceLocation[1] - 2);
                        if (this.memoryReferenceLocation[1] == -1 || this.memoryReferenceLocation[1] == -2) {
                            this.memoryReferenceLocation[0] = (byte)(this.memoryReferenceLocation[0] - 1);
                        }
                        this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                    }
                } else {
                    if ((this.addressByte >> 6 & 3) == 3) {
                        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    } else {
                        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                        this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    }
                    if (this.bitShift == 1) {
                        this.cpu.flags[11] = (this.sourceValue[0] & 0x80) == 128;
                    }
                    this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL) >> this.bitShift - 1;
                    this.carryBit = (int)(this.shiftResult & 1L);
                    this.shiftResult >>= 1;
                    this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                    this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                    if ((this.addressByte >> 6 & 3) != 3) {
                        this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                    }
                }
                this.cpu.flags[4] = false;
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (!this.cpu.doubleWord) {
                    this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0;
                    this.cpu.flags[7] = this.sourceValue[0] < 0;
                } else {
                    this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0 && this.eSourceValue[0] == 0 && this.eSourceValue[1] == 0;
                    this.cpu.flags[7] = this.eSourceValue[0] < 0;
                }
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[1]);
                break;
            }
            case 6: {
                throw new CPUInstructionException("Shift Group 2 (0xD2/6) illegal reg bits");
            }
            case 7: {
                if (this.bitShift <= 0) break;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                if (this.bitShift >= 16) {
                    if ((this.sourceValue[0] & 0x80) == 128) {
                        this.sourceValue[0] = -1;
                        this.sourceValue[1] = -1;
                    } else {
                        this.sourceValue[0] = 0;
                        this.sourceValue[1] = 0;
                    }
                } else {
                    this.shiftResult = ((long)this.sourceValue[0] << 8 & 0xFF00L) + ((long)this.sourceValue[1] & 0xFFL) >> this.bitShift - 1;
                    this.carryBit = (int)(this.shiftResult & 1L);
                    this.shiftResult >>= 1;
                    if ((this.sourceValue[0] & 0x80) == 128) {
                        this.shiftResult |= (long)(65535 << 16 - this.bitShift);
                    }
                }
                this.sourceValue[0] = (byte)(this.shiftResult >> 8 & 0xFFL);
                this.sourceValue[1] = (byte)(this.shiftResult & 0xFFL);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue);
                }
                this.cpu.flags[4] = false;
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift == 1) {
                    this.cpu.flags[11] = false;
                }
                this.cpu.flags[6] = this.sourceValue[0] == 0 && this.sourceValue[1] == 0;
                this.cpu.flags[7] = this.sourceValue[0] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[1]);
                break;
            }
            default: {
                throw new CPUInstructionException("Shift Group 2 (0xD2/6) no case match");
            }
        }
    }
}

